#include "d3d.h"
#include "inifile.h"
#include "vidxbs.h"
#include "../vidshared.h"

D3D g_d3d;
HRESULT g_hResult;
extern int vdp2width;
extern int vdp2height;

D3D::D3D(void)
{
	m_dwWidth = 640;
	m_dwHeight = 480;
}

D3D::~D3D(void)
{
}

bool D3D::Create()
{
	// create the direct 3d object
	m_pD3D = Direct3DCreate8(D3D_SDK_VERSION);

	if (m_pD3D == NULL)
		return false;

    // set up the structure used to create the d3d device
	D3DPRESENT_PARAMETERS d3dpp;
    ZeroMemory(&d3dpp, sizeof(d3dpp));

    d3dpp.BackBufferCount					= 1;
	d3dpp.EnableAutoDepthStencil			= FALSE;
	d3dpp.AutoDepthStencilFormat			= D3DFMT_D16;//D3DFMT_D24S8;
    d3dpp.SwapEffect						= D3DSWAPEFFECT_DISCARD;

	
	if(!g_iniFile.m_currentIniEntry.bVSync){
		d3dpp.FullScreen_PresentationInterval	= D3DPRESENT_INTERVAL_IMMEDIATE;
	}else{
		d3dpp.FullScreen_PresentationInterval	= D3DPRESENT_INTERVAL_ONE;
	}

	DWORD videoFlags = XGetVideoFlags();
	if(XGetVideoStandard() == XC_VIDEO_STANDARD_PAL_I)
	{
		if(videoFlags & XC_VIDEO_FLAGS_PAL_60Hz)		// PAL 60 user
			d3dpp.FullScreen_RefreshRateInHz = 60;
		else
			d3dpp.FullScreen_RefreshRateInHz = 50;
	}

	if(g_iniFile.m_currentIniEntry.iResolution == RESOLUTION_1080I)
	{
		if(XGetAVPack() == XC_AV_PACK_HDTV)
		{
			if(videoFlags & XC_VIDEO_FLAGS_HDTV_1080i)
				{
					m_dwWidth = 1920;
					m_dwHeight = 1080;
					d3dpp.Flags = D3DPRESENTFLAG_INTERLACED | D3DPRESENTFLAG_WIDESCREEN;
				}
					else
				{
					g_iniFile.m_currentIniEntry.iResolution = RESOLUTION_720P;
				}
		}
			else
		{
			g_iniFile.m_currentIniEntry.iResolution = RESOLUTION_480I;
		}
	}
	
	if(g_iniFile.m_currentIniEntry.iResolution == RESOLUTION_720P)
	{
		if(XGetAVPack() == XC_AV_PACK_HDTV)
		{
			if(videoFlags & XC_VIDEO_FLAGS_HDTV_720p)
				{
					m_dwWidth = 1280;
					m_dwHeight = 720;
					d3dpp.Flags	= D3DPRESENTFLAG_PROGRESSIVE | D3DPRESENTFLAG_WIDESCREEN;
				}
					else
				{
					g_iniFile.m_currentIniEntry.iResolution = RESOLUTION_480P;
				}
		}
			else
		{
			g_iniFile.m_currentIniEntry.iResolution = RESOLUTION_480I;
		}
	}
	
	if(g_iniFile.m_currentIniEntry.iResolution == RESOLUTION_480P)
	{
		if(XGetAVPack() == XC_AV_PACK_HDTV)
		{
			if(videoFlags & XC_VIDEO_FLAGS_HDTV_720p)
				{
					m_dwWidth = 640;
					m_dwHeight = 480;
					d3dpp.Flags = D3DPRESENTFLAG_PROGRESSIVE;
				}
				else
				{
					g_iniFile.m_currentIniEntry.iResolution = RESOLUTION_480I;
				}
		}
			else
		{
			g_iniFile.m_currentIniEntry.iResolution = RESOLUTION_480I;
		}
	}
	
	if(g_iniFile.m_currentIniEntry.iResolution == RESOLUTION_480I)
	{
		m_dwWidth = 640;
		m_dwHeight = 480;
		d3dpp.Flags = D3DPRESENTFLAG_INTERLACED;
	}

	
	d3dpp.BackBufferWidth        = m_dwWidth;
    d3dpp.BackBufferHeight       = m_dwHeight;
    d3dpp.BackBufferFormat		 = D3DFMT_LIN_A8R8G8B8;


	g_hResult = m_pD3D->CreateDevice(0, D3DDEVTYPE_HAL, NULL, 
									 D3DCREATE_HARDWARE_VERTEXPROCESSING,
									 &d3dpp, &m_pD3DDevice);
	if (FAILED(g_hResult))
		return false;

	// use an orthogonal matrix for the projection matrix
    D3DXMATRIX mat;

	D3DXMatrixOrthoOffCenterLH(&mat, 0, m_dwWidth, m_dwHeight, 0, 0.0f, 1.0f);

    m_pD3DDevice->SetTransform(D3DTS_PROJECTION, &mat);

	// use an identity matrix for the world and view matrices
	D3DXMatrixIdentity(&mat);
	m_pD3DDevice->SetTransform(D3DTS_WORLD, &mat);
	m_pD3DDevice->SetTransform(D3DTS_VIEW, &mat);

	// disable lighting
	m_pD3DDevice->SetRenderState(D3DRS_LIGHTING, FALSE);

	// disable z-buffer (see autodepthstencil)
	m_pD3DDevice->SetRenderState(D3DRS_ZENABLE, FALSE );


	D3DVIEWPORT8 viewport;
	viewport.X = 0;
	viewport.Y = 0;
	viewport.Width = m_dwWidth;
	viewport.Height = m_dwHeight;
	viewport.MinZ = 0.0f;
	viewport.MaxZ = 1.0f;

	m_pD3DDevice->SetViewport(&viewport);
	
	return true;
}

bool D3D::CreateVertexBuffer(dword Length)
{

	CustomVertex g_Vertices[] =
    {
        {  g_iniFile.m_currentIniEntry.iXPOS,				g_iniFile.m_currentIniEntry.iYPOS,				0.0f, 0.0f, 0.0f }, // x, y, z, u, v
		{  g_iniFile.m_currentIniEntry.iXPOS + m_dwWidth,	g_iniFile.m_currentIniEntry.iYPOS,				0.0f, 1.0f, 0.0f }, // x, y, z, u, v
		{  g_iniFile.m_currentIniEntry.iXPOS,				g_iniFile.m_currentIniEntry.iYPOS + m_dwHeight, 0.0f, 0.0f, 1.0f }, // x, y, z, u, v
		{  g_iniFile.m_currentIniEntry.iXPOS + m_dwWidth,	g_iniFile.m_currentIniEntry.iYPOS + m_dwHeight, 0.0f, 1.0f, 1.0f }, // x, y, z, u, v

    };

	g_hResult = m_pD3DDevice->CreateVertexBuffer(
												Length, //Length
												D3DUSAGE_WRITEONLY, 
												D3DFVF_CUSTOMVERTEX,
												D3DPOOL_MANAGED, //Unused
												&m_pVertexBuffer); //Vertex buffer
	if (FAILED(g_hResult))
		return false;

	CustomVertex* pVertices;
    if( FAILED( m_pVertexBuffer->Lock( 0, 0, (BYTE**)&pVertices, 0 ) ) )
        return false; //E_FAIL;
    memcpy( pVertices, g_Vertices, Length );
    m_pVertexBuffer->Unlock();

	return true;
}

bool D3D::CreateTexture(dword id, dword width, dword height)
{
		g_hResult = m_pD3DDevice->CreateTexture
		(
			width,
			height,
			1,
			0,
			D3DFMT_A8R8G8B8,
			D3DPOOL_MANAGED,
			&m_pTexture[id]
		);

	if (FAILED(g_hResult))
		return false;

	m_pD3DDevice->SetTextureStageState(0,D3DTSS_ALPHAOP, D3DTOP_DISABLE);

	if(g_iniFile.m_currentIniEntry.dwTextureFilter == 0)
	{
		m_pD3DDevice->SetTextureStageState(0,D3DTSS_MAGFILTER, D3DTEXF_POINT);
		m_pD3DDevice->SetTextureStageState(0,D3DTSS_MINFILTER, D3DTEXF_POINT);
	}
	else 
	if (g_iniFile.m_currentIniEntry.dwTextureFilter == 1)
	{
		m_pD3DDevice->SetTextureStageState(0,D3DTSS_MAGFILTER, D3DTEXF_LINEAR);
		m_pD3DDevice->SetTextureStageState(0,D3DTSS_MINFILTER, D3DTEXF_LINEAR);
	}

return true;
}
/*
bool D3D::CreateSpriteInterface()
{
	g_hResult = D3DXCreateSprite(m_pD3DDevice, &m_pSprite);
	if (FAILED(g_hResult))
		return false;


	// create a new texture that we will render on
	g_hResult = m_pD3DDevice->CreateTexture
		(
			512,
			256,
			1,
			0,
			D3DFMT_A8R8G8B8,
			D3DPOOL_MANAGED,
			&m_pTexture[0]
		);
	if (FAILED(g_hResult))
		return false;

	m_pD3DDevice->SetTextureStageState(0,D3DTSS_ALPHAOP,   D3DTOP_DISABLE);
	m_pD3DDevice->SetTextureStageState(0,D3DTSS_MAGFILTER, D3DTEXF_LINEAR);
    m_pD3DDevice->SetTextureStageState(0,D3DTSS_MINFILTER, D3DTEXF_LINEAR);

	return true;
}*/


void D3D::BeginRender()
{

	//m_pD3DDevice->Clear( 0L, NULL, D3DCLEAR_TARGET/*|D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL*/, D3DCOLOR_XRGB(0,0,0), 1.0f, 0L );

    //m_pD3DDevice->BeginScene();

	// now hack in some DWORDS :-P
	m_pD3DDevice->SetFlickerFilter(g_iniFile.m_currentIniEntry.dwFlickerFilter); 
	m_pD3DDevice->SetSoftDisplayFilter(g_iniFile.m_currentIniEntry.bSoftDisplayFilter);

}

void D3D::EndRender()
{
	//m_pD3DDevice->EndScene();

	m_pD3DDevice->Present(NULL, NULL, NULL, NULL);
}
